const db = require("../config/dbConfig");

async function insertTraccarToken(data) {
  const sql = `
  INSERT INTO traccar_user_tokens (traccar_user_id, token)
      VALUES (?, ?)
      ON DUPLICATE KEY UPDATE
        token = VALUES(token);
    `;

  try {
    await db.query(sql, [
      data.userId,
      data.traccar_token,
    ]);
    console.log("Data inserted successfully.");
    return true;
  } catch (error) {
    console.error("Error while inserting data:", error);
    return false;
  }
}

function getTraccarToken(callback) {
    const TraccarTokenSql = 'SELECT * FROM traccar_user_tokens';
    db.query(TraccarTokenSql, (error, TraccarTokenResults) => {
        if (error) {
            console.error('Error:', error);
            callback(error, null);
        } else {
            callback(null, TraccarTokenResults);
        }
    });
}

function getTraccarTokenById(traccarUserId, callback) {
    const TraccarTokenByIdSql = 'SELECT * FROM traccar_user_tokens WHERE traccar_user_id = ?';
    db.query(TraccarTokenByIdSql, [traccarUserId], (error, TraccarTokenByIdResults) => {
        if (error) {
            console.error('Error:', error);
            callback(error, null);
        } else {
            callback(null, TraccarTokenByIdResults);
        }
    });
}


module.exports = {
  insertTraccarToken,
  getTraccarToken,
  getTraccarTokenById
};
