const db = require("../config/dbConfig");

async function insertOrUpdateCalcStopDectector(dataArray) {
  const sql = `
  INSERT INTO calc_stop_detector (data_id, calc_id, calc_name,device_id, device_name, begin, duration, end, route, timestamp)
  VALUES
  (?,?,?,?,?,?,?,?,?,?)
  ON DUPLICATE KEY UPDATE
    timestamp = VALUES(timestamp);
    `;

  for (const item of dataArray) {
    try {
      await db.query(sql, [
        item.data.id,
        item.calc_id,
        item.calc_name,
        item.device_id,
        item.device_name,
        item.data.begin,
        item.data.duration,
        item.data.end,
        item.data.route,
        item.data.timestamp,
      ]);
    } catch (error) {
      console.error("Error while inserting or updating data:", error);
    }
  }
}

function getCalcStopDectector(callback) {
  const calcBitrekSql = "SELECT * FROM calc_stop_detector";
  db.query(calcBitrekSql, (error, calcBitrekResults) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, calcBitrekResults);
    }
  });
}


function getCalcStopDectectorByDeviceId(deviceIdsArray, callback) {
  if (deviceIdsArray.length === 0) {
    callback(null, []);
    return;
  }
  const deviceIdQuery = "SELECT * FROM calc_stop_detector WHERE device_id IN (?)";
  db.query(deviceIdQuery, [deviceIdsArray], (error, result) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, result);
    }
  });
}

module.exports = {
    insertOrUpdateCalcStopDectector,
    getCalcStopDectector,
    getCalcStopDectectorByDeviceId
};
