const db = require("../config/dbConfig");

async function insertOrUpdateCalcFuelConsumed(dataArray) {
  const sql = `
    INSERT INTO calc_fuel_consumed (data_id,calc_id,device_id,begin,imei,duration,end,timestamp,fuel_end,fuel_start,odometer_end,odometer_start,odometer_total,driver_id,fuel_total_day)
      VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
      ON DUPLICATE KEY UPDATE
      timestamp = VALUES(timestamp);
    `;

  for (const item of dataArray) {
    try {
      const driverId = item["driver.id"] || [];
      await db.query(sql, [
        item.id,
        item.calc_id,
        item["device.id"],
        item.begin,
        item.imei,
        item.duration,
        item.end,
        item.timestamp,
        item["fuel.end"],
        item["fuel.start"],
        item["odometer.end"],
        item["odometer.start"],
        item["odometer.total"],
        JSON.stringify(driverId),
        item["fuel.total.day"],
      ]);
    } catch (error) {
      console.error("Error while inserting or updating data:", error);
    }
  }
}

function getCalcFuelConsumed(callback) {
  const calcFuelConsumedSql = "SELECT * FROM calc_fuel_consumed";
  db.query(calcFuelConsumedSql, (error, calcFuelConsumedResults) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, calcFuelConsumedResults);
    }
  });
}


function getCalcFuelConsumedByDeviceId(deviceIdsArray, callback) {
  if (deviceIdsArray.length === 0) {
    callback(null, []);
    return;
  }
  const deviceIdQuery = "SELECT * FROM calc_fuel_consumed WHERE device_id IN (?)";
  db.query(deviceIdQuery, [deviceIdsArray], (error, result) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, result);
    }
  });
}

module.exports = {
  insertOrUpdateCalcFuelConsumed,
  getCalcFuelConsumed,
  getCalcFuelConsumedByDeviceId
};
