const db = require("../config/dbConfig");

async function insertOrUpdateCalcDailyTravelLogs(dataArray) {
  const sql = `
    INSERT INTO calc_daily_log_travel (data_id,calc_id,device_id,avg_speed,begin,can_trip_max_rpm,can_trip_mileage,can_trip_time,date_begin,date_end,device_name,distance,distance_can,driver_id,duration,duration_minutes,end,max_speed,route,timestamp,trip_fuel_consumed)
      VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
      ON DUPLICATE KEY UPDATE
      timestamp = VALUES(timestamp);
    `;

  for (const item of dataArray) {
    try {
        const driverId = item["driver.id"] || [];
      await db.query(sql, [
        item.id,
        item.calc_id,
        item["device.id"],
        item["avg.speed"],
        item.begin,
        item["can.trip.max.rpm"],
        item["can.trip.mileage"],
        item["can.trip.time"],
        item["date.begin"],
        item["date.end"],
        item["device.name"],
        item.distance,
        item.distance_can,
        JSON.stringify(driverId),
        item.duration,
        item["duration.minutes"],
        item.end,
        item["max.speed"],
        item.route,
        item.timestamp,
        item["trip.fuel.consumed"],
      ]);
    } catch (error) {
      console.error("Error while inserting or updating data:", error);
    }
  }
}

function getCalcDailyTravelLogs(callback) {
  const calcDailyTravelLogsSql = "SELECT * FROM calc_daily_log_travel";
  db.query(calcDailyTravelLogsSql, (error, calcDailyTravelLogsResults) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, calcDailyTravelLogsResults);
    }
  });
}


function getCalcDailyTravelLogsByDeviceId(deviceIdsArray, callback) {
  if (deviceIdsArray.length === 0) {
    callback(null, []);
    return;
  }
  const deviceIdQuery = "SELECT * FROM calc_daily_log_travel WHERE device_id IN (?)";
  db.query(deviceIdQuery, [deviceIdsArray], (error, result) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, result);
    }
  });
}



module.exports = {
  insertOrUpdateCalcDailyTravelLogs,
  getCalcDailyTravelLogs,
  getCalcDailyTravelLogsByDeviceId
};
