const db = require('../config/dbConfig');
  
async function insertOrUpdateCalcBitrekData(data) {
    const sql = `
      INSERT INTO calc_bitrek (
        data_id, avg_speed, begin, duration, end, idle_hours,
        max_speed, motion_hours, motion_seconds, odometer_end,
        odometer_start, running_seconds_par5, stop_hours, timestamp,
        total_mileage, work_hours
      )
      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
      ON DUPLICATE KEY UPDATE
        avg_speed = VALUES(avg_speed),
        begin = VALUES(begin),
        duration = VALUES(duration),
        end = VALUES(end),
        idle_hours = VALUES(idle_hours),
        max_speed = VALUES(max_speed),
        motion_hours = VALUES(motion_hours),
        motion_seconds = VALUES(motion_seconds),
        odometer_end = VALUES(odometer_end),
        odometer_start = VALUES(odometer_start),
        running_seconds_par5 = VALUES(running_seconds_par5),
        stop_hours = VALUES(stop_hours),
        timestamp = VALUES(timestamp),
        total_mileage = VALUES(total_mileage),
        work_hours = VALUES(work_hours);
    `;
  
    for (const item of data) {
      try {
        await db.query(sql, [
          item.id,
          item['avg.speed'],
          item.begin,
          item.duration,
          item.end,
          item['idle.hours'],
          item['max.speed'],
          item['motion.hours'],
          item['motion.seconds'],
          item['odometer.end'],
          item['odometer.start'],
          item['running.seconds.par5'],
          item['stop.hours'],
          item.timestamp,
          item['total.mileage'],
          item['work.hours']
        ]);
      } catch (error) {
        console.error('Error while inserting or updating data:', error);
      }
    }
  }
 
  function getCalcBitrek(callback) {
    const calcBitrekSql = 'SELECT * FROM calc_Bitrek';
    db.query(calcBitrekSql, (error, calcBitrekResults) => {
        if (error) {
            console.error('Error:', error);
            callback(error, null);
        } else {
            callback(null, calcBitrekResults);
        }
    });
}

module.exports = { 	insertOrUpdateCalcBitrekData, getCalcBitrek };
