const db = require("../config/dbConfig");

async function insertOrUpdateDeviceData(data) {
    const sql = `
      INSERT INTO device_data (
        created_by, traccar_id, traccar_attributes, traccar_group_id, traccar_calendar_id,
        traccar_name, traccar_unique_id, traccar_status, traccar_last_update,
        traccar_position_id, traccar_phone, traccar_model, traccar_contact,
        traccar_category, traccar_disabled, traccar_expiration_time,
        flespi_messages_ttl, flespi_protocol_id, flespi_device_type_id, flespi_id,
        flespi_media_ttl, flespi_name, flespi_configuration, flespi_cid,
        flespi_media_rotate, flespi_messages_rotate
      )
      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
      ON DUPLICATE KEY UPDATE
        flespi_messages_rotate = VALUES(flespi_messages_rotate);
    `;
  
    for (const item of data) {
      try {
        await db.query(sql, [
          item.created_by,
          item.traccarData.id,
          JSON.stringify(item.traccarData.attributes),
          item.traccarData.groupId,
          item.traccarData.calendarId,
          item.traccarData.name,
          item.traccarData.uniqueId,
          item.traccarData.status,
          item.traccarData.lastUpdate,
          item.traccarData.positionId,
          item.traccarData.phone,
          item.traccarData.model,
          item.traccarData.contact,
          item.traccarData.category,
          item.traccarData.disabled,
          item.traccarData.expirationTime,
          item.flespiData.messages_ttl,
          item.flespiData.protocol_id,
          item.flespiData.device_type_id,
          item.flespiData.id,
          item.flespiData.media_ttl,
          item.flespiData.name,
          JSON.stringify(item.flespiData.configuration),
          item.flespiData.cid,
          item.flespiData.media_rotate,
          item.flespiData.messages_rotate,
        ]);
      } catch (error) {
        console.error("Error while inserting or updating data:", error);
      }
    }
  }
  
  function getDeviceData(createdBy, callback) {
    const deviceDataSql = "SELECT * FROM device_data WHERE created_by = ?";
    db.query(deviceDataSql, [createdBy], (error, deviceDataResults) => {
      if (error) {
        console.error("Error:", error);
        callback(error, null);
      } else {
        callback(null, deviceDataResults);
      }
    });
  }
  

module.exports = { insertOrUpdateDeviceData, getDeviceData };
