const db = require("../config/dbConfig");

async function insertOrUpdateCalcParadas(dataArray) {
  const sql = `
    INSERT INTO calc_paradas (data_id,calc_id,device_id,Encendido,begin,date_begin,date_end,device_name,driver_id,duration,duration_min,end,route,timestamp)
      VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)
      ON DUPLICATE KEY UPDATE
      timestamp = VALUES(timestamp);
    `;

  for (const item of dataArray) {
    try {
      const driverId = item["driver.id"] || [];
      await db.query(sql, [
        item.id,
        item.calc_id,
        item["device.id"],
        item.Encendido,
        item.begin,
        item["date.begin"],
        item["date.end"],
        item["device.name"],
        JSON.stringify(driverId),
        item.duration,
        item["duration.min"],
        item.end,
        item.route,
        item.timestamp,
      ]);
    } catch (error) {
      console.error("Error while inserting or updating data:", error);
    }
  }
}

function getCalcParadas(callback) {
  const calcParadasSql = "SELECT * FROM calc_paradas";
  db.query(calcParadasSql, (error, calcParadasResults) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, calcParadasResults);
    }
  });
}

function getCalcParadasByDeviceId(deviceIdsArray, callback) {
  if (deviceIdsArray.length === 0) {
    callback(null, []);
    return;
  }
  const deviceIdQuery = "SELECT * FROM calc_paradas WHERE device_id IN (?)";
  db.query(deviceIdQuery, [deviceIdsArray], (error, result) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, result);
    }
  });
}



module.exports = {
  insertOrUpdateCalcParadas,
  getCalcParadas,
  getCalcParadasByDeviceId
};
