const db = require("../config/dbConfig");

async function insertOrUpdateCalcChecklistOpt(dataArray) {
  const sql = `
    INSERT INTO calc_checklist_operators (data_id,calc_id,device_id,begin,imei,duration,end,timestamp,protocol_id,certificate,ssl_value,ip_peer,ope,operador,operator,server_key)
      VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
      ON DUPLICATE KEY UPDATE
      timestamp = VALUES(timestamp);
    `;

  for (const item of dataArray) {
    try {
      
      const operadorjson = item.operador || {};
      await db.query(sql, [
        item.id,
        item.calc_id,
        item["device.id"],
        item.begin,
        item.imei,
        item.duration,
        item.end,
        item.timestamp,
        item["protocol.id"],
        item.certificate,
        item.ssl ? 1 : 0,
        item["ip.peer"],
        item.ope ? 1 : 0,
        JSON.stringify(operadorjson),
        item.operator ? 1 : 0,
        item["server.key"],
      ]);
    } catch (error) {
      console.error("Error while inserting or updating data:", error);
    }
  }
}

function getCalcChecklistOpt(callback) {
  const calcChecklistOptSql = "SELECT * FROM calc_checklist_operators";
  db.query(calcChecklistOptSql, (error, calcChecklistOptResults) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, calcChecklistOptResults);
    }
  });
}

function getCalcChecklistOptByDeviceId(deviceIdsArray, callback) {
  if (deviceIdsArray.length === 0) {
    callback(null, []);
    return;
  }
  const deviceIdQuery = "SELECT * FROM calc_checklist_operators WHERE device_id IN (?)";
  db.query(deviceIdQuery, [deviceIdsArray], (error, result) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, result);
    }
  });
}


module.exports = {
  insertOrUpdateCalcChecklistOpt,
  getCalcChecklistOpt,
  getCalcChecklistOptByDeviceId
};
