const jwt = require('jsonwebtoken');

const secretKey = process.env.ACCESS_TOKEN_SECRET; 

function generateToken(userId) {
  const token = jwt.sign({ userId }, secretKey, { expiresIn: '10h' });
  return token;
}

function verifyToken(token) {
  try {
    const decoded = jwt.verify(token, secretKey);
    return decoded;
  } catch (error) {
    throw error;
  }
}

module.exports = {
  generateToken,
  verifyToken,
};
