const db = require("../config/dbConfig");

// async function insertSubAccount(data) {
//   const sql = `
//       INSERT INTO sub_accounts (sla, owner_id, limit_id, region, subaccount_id, created, notify, name, cid, confirmed, email)
//       VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
//     `;

//   try {
//     await db.query(sql, [
//       data.sla,
//       data.owner_id,
//       data.limit_id,
//       data.region,
//       data.id,
//       data.created,
//       data.notify,
//       data.name,
//       data.cid,
//       data.confirmed,
//       data.email,
//     ]);
//     console.log("Data inserted successfully.");
//     return true;
//   } catch (error) {
//     console.error("Error while inserting data:", error);
//     return false;
//   }
// }


async function insertFlespiTracaarAcc(data) {
  const sql = `
      INSERT INTO flespi_traccar_acc (created_by, flespi_sla, flespi_owner_id, flespi_limit_id, flespi_region, flespi_id, flespi_created, flespi_notify, flespi_name, flespi_cid, flespi_confirmed, flespi_email, traccar_id, traccar_name, traccar_email, traccar_login, traccar_phone, traccar_readonly, traccar_administrator, traccar_map, traccar_latitude, traccar_longitude, traccar_zoom, traccar_twelveHourFormat, traccar_coordinateFormat, traccar_disabled, traccar_expirationTime, traccar_deviceLimit, traccar_userLimit, traccar_deviceReadonly, traccar_limitCommands, traccar_disableReports, traccar_fixedEmail, traccar_poiLayer, traccar_password_hash )
      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )
    `;

  try {
    await db.query(sql, [
      data.created_by,
      data.flespi.sla,
      data.flespi.owner_id,
      data.flespi.limit_id,
      data.flespi.region,
      data.flespi.id,
      data.flespi.created,
      data.flespi.notify,
      data.flespi.name,
      data.flespi.cid,
      data.flespi.confirmed,
      data.flespi.email,
      data.traccar.id,
      data.traccar.name,
      data.traccar.email,
      data.traccar.login,
      data.traccar.phone,
      data.traccar.readonly ? 1 : 0,
      data.traccar.administrator ? 1 : 0,
      data.traccar.map,
      data.traccar.latitude,
      data.traccar.longitude,
      data.traccar.zoom,
      data.traccar.twelveHourFormat ? 1 : 0,
      data.traccar.coordinateFormat,
      data.traccar.disabled ? 1 : 0,
      data.traccar.expirationTime,
      data.traccar.deviceLimit,
      data.traccar.userLimit,
      data.traccar.deviceReadonly ? 1 : 0,
      data.traccar.limitCommands ? 1 : 0,
      data.traccar.disableReports ? 1 : 0,
      data.traccar.fixedEmail ? 1 : 0,
      data.traccar.poiLayer,
      data.traccar.password,
    ]);
    console.log("Data inserted successfully.");
    return true;
  } catch (error) {
    console.error("Error while inserting data:", error);
    return false;
  }
}

// function getSubAccounts(createdBy, callback) {
//   const subAccountsSql =
//     "SELECT * FROM flespi_traccar_acc WHERE deleted_at IS NULL AND created_by = ? ORDER BY created_at DESC";
//   db.query(subAccountsSql, [createdBy], (error, subAccountsResults) => {
//     if (error) {
//       console.error("Error:", error);
//       callback(error, null);
//     } else {
//       callback(null, subAccountsResults);
//     }
//   });
// }

function getSubAccounts(createdBy, isSuperAdmin, callback) {
  let subAccountsSql;

  const selectedFields = [
    'id',
    'flespi_name',
    'flespi_id',
    'flespi_email',
    'traccar_id',
    'traccar_name',
    'traccar_email',
    "flespi_owner_id",
    "flespi_region",
    "flespi_created",
  ].join(', ');

  if (isSuperAdmin) {
    subAccountsSql = `
      SELECT ${selectedFields} 
      FROM flespi_traccar_acc 
      WHERE deleted_at IS NULL 
      ORDER BY created_at DESC`;
  } else {
    subAccountsSql = `
      SELECT ${selectedFields} 
      FROM flespi_traccar_acc 
      WHERE deleted_at IS NULL AND created_by = ? 
      ORDER BY created_at DESC`;
  }

  const queryParams = isSuperAdmin ? [] : [createdBy];

  db.query(subAccountsSql, queryParams, (error, subAccountsResults) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, subAccountsResults);
    }
  });
}


function getSubAccountById(subaccount_id, callback) {
    const subAccountSql =
      "SELECT * FROM flespi_traccar_acc WHERE flespi_id = ? AND deleted_at IS NULL";
    db.query(subAccountSql, [subaccount_id], (error, subAccountResult) => {
      if (error) {
        console.error("Error:", error);
        callback(error, null);
      } else {
        if (subAccountResult.length > 0) {
          callback(null, subAccountResult[0]);
        } else {
          callback(null, null); 
        }
      }
    });
  }

module.exports = {
  insertFlespiTracaarAcc,
  getSubAccounts,
  getSubAccountById,
};
