const db = require("../config/dbConfig");

async function insertOrUpdateCalcRefuel(dataArray) {
  const sql = `
    INSERT INTO calc_refuel (data_id,calc_id,device_id,begin,imei,duration,end,timestamp,fuel_after,fuel_before,fuel_delta,position_latitude,position_longitude,odometer,driver_id,driver_id2)
      VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
      ON DUPLICATE KEY UPDATE
      timestamp = VALUES(timestamp);
    `;

  for (const item of dataArray) {
    try {
      const driverId2 = item["driver.id2"] || [];
      const driverId = item["driver.id"] || [];
      await db.query(sql, [
        item.id,
        item.calc_id,
        item["device.id"],
        item.begin,
        item.imei,
        item.duration,
        item.end,
        item.timestamp,
        item["fuel.after"],
        item["fuel.before"],
        item["fuel.delta"],
        item["position.latitude"],
        item["position.longitude"],
        item.odometer,
        JSON.stringify(driverId),
        JSON.stringify(driverId2),
      ]);
    } catch (error) {
      console.error("Error while inserting or updating data:", error);
    }
  }
}

function getCalcRefuel(callback) {
  const calcRefuelSql = "SELECT * FROM calc_refuel";
  db.query(calcRefuelSql, (error, calcRefuelResults) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, calcRefuelResults);
    }
  });
}


function getCalcRefuelByDeviceId(deviceIdsArray, callback) {
  if (deviceIdsArray.length === 0) {
    callback(null, []);
    return;
  }
  const deviceIdQuery = "SELECT * FROM calc_refuel WHERE device_id IN (?)";
  db.query(deviceIdQuery, [deviceIdsArray], (error, result) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, result);
    }
  });
}

module.exports = {
  insertOrUpdateCalcRefuel,
  getCalcRefuel,
  getCalcRefuelByDeviceId
};
