const db = require("../../config/dbConfig");
const util = require("util");
const dbQuery = util.promisify(db.query).bind(db);

async function createUser(data) {
  const sql = `
      INSERT INTO settings_users (
        userId,
        traccarId,
        flespiId,
        deviceLimit,
        name,
        email,
        phone,
        attributes,
        poiLayer,
        twelveHourFormat,
        map,
        coordinateFormat,
        latitude,
        longitude,
        zoom,
        expirationTime,
        userLimit,
        administrator,
        readonly,
        deviceReadonly,
        limitCommands,
        disableReports,
        fixedEmail,
        flespi_metadata
      )
      VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? );
    `;

  const values = [
    data.userId,
    data.traccar.id,
    data.flespi.id,
    data.traccar.deviceLimit,
    data.traccar.name,
    data.traccar.email,
    data.traccar.phone,
    JSON.stringify(data.traccar.attributes),
    data.traccar.poiLayer,
    data.traccar.twelveHourFormat,
    data.traccar.map,
    data.traccar.coordinateFormat,
    data.traccar.latitude,
    data.traccar.longitude,
    data.traccar.zoom,
    data.traccar.expirationTime,
    data.traccar.userLimit,
    data.traccar.administrator,
    data.traccar.readonly,
    data.traccar.deviceReadonly,
    data.traccar.limitCommands,
    data.traccar.disableReports,
    data.traccar.fixedEmail,
    JSON.stringify(data.flespi.metadata),
  ];

  try {
    const result = await dbQuery(sql, values);
    return result.insertId;
  } catch (err) {
    throw err;
  }
}

async function getAllUsers() {
  const sql =
    "SELECT id, traccarId, flespiId, deviceLimit, userId, name, email, phone, attributes, poiLayer, twelveHourFormat, map, coordinateFormat, latitude, longitude, zoom, expirationTime, userLimit, administrator, readonly, deviceReadonly, limitCommands,disableReports, fixedEmail, created_at FROM settings_users WHERE deleted_at IS NULL;";

  try {
    const result = await dbQuery(sql);

    if (result.length > 0) {
      const devices = result.map((device) => {
        device.attributes = JSON.parse(device.attributes);
        return device;
      });

      return devices;
    } else {
      return [];
    }
  } catch (error) {
    throw error;
  }
}

async function getUserById(deviceId) {
  const sql =
    "SELECT id, traccarId, flespiId, deviceLimit, userId, name, email, phone, attributes, poiLayer, twelveHourFormat, map, coordinateFormat, latitude, longitude, zoom, expirationTime, userLimit, administrator, readonly, deviceReadonly, limitCommands, disableReports, fixedEmail, created_at FROM settings_users WHERE id = ? AND deleted_at IS NULL;";
  const values = [deviceId];

  try {
    const result = await dbQuery(sql, values);

    if (result.length > 0) {
      const device = result[0];
      device.attributes = JSON.parse(device.attributes);

      return device;
    } else {
      return null;
    }
  } catch (error) {
    throw error;
  }
}

async function getUsersByUserId(userId) {
  const sql =
    "SELECT id, traccarId, flespiId, deviceLimit, userId, name, email, phone, attributes, poiLayer, twelveHourFormat, map, coordinateFormat, latitude, longitude, zoom, expirationTime, userLimit, administrator, readonly, deviceReadonly, limitCommands,disableReports, fixedEmail, created_at FROM settings_users WHERE userId = ? AND deleted_at IS NULL;";
  const values = [userId];

  try {
    const result = await dbQuery(sql, values);

    if (result.length > 0) {
      const devices = result.map((device) => {
        device.attributes = JSON.parse(device.attributes);
        return device;
      });

      return devices;
    } else {
      return [];
    }
  } catch (error) {
    throw error;
  }
}

async function updateUserById(id, updatedData) {
  const sql = `
    UPDATE settings_users
    SET
      traccarId = ?,
      flespiId = ?,
      deviceLimit = ?,
      name = ?,
      email = ?,
      phone = ?,
      attributes = ?,
      poiLayer = ?,
      twelveHourFormat = ?,
      map = ?,
      coordinateFormat = ?,
      latitude = ?,
      longitude = ?,
      zoom = ?,
      expirationTime = ?,
      userLimit = ?,
      administrator = ?,
      readonly = ?,
      deviceReadonly = ?,
      limitCommands = ?,
      disableReports = ?,
      fixedEmail = ?,
      flespi_metadata = ?
    WHERE id = ?;
  `;

  const values = [
    updatedData.traccar.id,
    updatedData.flespi.id,
    updatedData.traccar.deviceLimit,
    updatedData.traccar.name,
    updatedData.traccar.email,
    updatedData.traccar.phone,
    JSON.stringify(updatedData.traccar.attributes),
    updatedData.traccar.poiLayer,
    updatedData.traccar.twelveHourFormat,
    updatedData.traccar.map,
    updatedData.traccar.coordinateFormat,
    updatedData.traccar.latitude,
    updatedData.traccar.longitude,
    updatedData.traccar.zoom,
    updatedData.traccar.expirationTime,
    updatedData.traccar.userLimit,
    updatedData.traccar.administrator,
    updatedData.traccar.readonly,
    updatedData.traccar.deviceReadonly,
    updatedData.traccar.limitCommands,
    updatedData.traccar.disableReports,
    updatedData.traccar.fixedEmail,
    JSON.stringify(updatedData.flespi.metadata),
    id,
  ];

  try {
    const result = await dbQuery(sql, values);
    if (result.affectedRows === 0) {
      throw new Error(`User with ID ${id} not found.`);
    }

    const updatedUser = {
      id,
      traccar: { ...updatedData.traccar },
      flespi: { ...updatedData.flespi },
    };

    return updatedUser;
  } catch (err) {
    throw err;
  }
}


async function softDeleteUserById(id) {
    const sql = `
        UPDATE settings_users
        SET
            deleted_at = CURRENT_TIMESTAMP
        WHERE
            id = ?;
    `;

    const values = [id];

    try {
        const result = await dbQuery(sql, values);
        return result.affectedRows;
    } catch (err) {
        throw err;
    }
}

module.exports = {
    createUser,
    getAllUsers,
    getUserById,
    getUsersByUserId,
    updateUserById,
    softDeleteUserById
};
