const db = require("../../config/dbConfig");
const util = require("util");
const dbQuery = util.promisify(db.query).bind(db);

async function IOU_1674670(data) {
  const sql = `
    INSERT INTO reports_1674670
      (\`begin\`, \`device.id\`, \`device.name\`, \`driver.id\`, \`duration\`, \`end\`, \`fuel.after\`,
      \`fuel.before\`, \`fuel.delta\`, \`id\`, \`imei\`, \`odometer\`, \`position.latitude\`, \`position.longitude\`,
      \`rfid.validation\`, \`timestamp\`)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE
      \`begin\` = VALUES(\`begin\`),
      \`device.id\` = VALUES(\`device.id\`),
      \`device.name\` = VALUES(\`device.name\`),
      \`driver.id\` = VALUES(\`driver.id\`),
      \`duration\` = VALUES(\`duration\`),
      \`end\` = VALUES(\`end\`),
      \`fuel.after\` = VALUES(\`fuel.after\`),
      \`fuel.before\` = VALUES(\`fuel.before\`),
      \`fuel.delta\` = VALUES(\`fuel.delta\`),
      \`imei\` = VALUES(\`imei\`),
      \`odometer\` = VALUES(\`odometer\`),
      \`position.latitude\` = VALUES(\`position.latitude\`),
      \`position.longitude\` = VALUES(\`position.longitude\`),
      \`rfid.validation\` = VALUES(\`rfid.validation\`),
      \`timestamp\` = VALUES(\`timestamp\`);
  `;

  const values = [
    data['begin'],
    data['device.id'],
    data['device.name'],
    JSON.stringify(data['driver.id']),
    data['duration'],
    data['end'],
    data['fuel.after'],
    data['fuel.before'],
    data['fuel.delta'],
    data['id'],
    data['imei'],
    data['odometer'],
    data['position.latitude'],
    data['position.longitude'],
    data['rfid.validation'],
    data['timestamp'],
  ];

  try {
    const result = await dbQuery(sql, values);
    return result.insertId;
  } catch (err) {
    throw err;
  }
}

async function IOU_1674833(data) {
  const sql = `
    INSERT INTO reports_1674833
      (\`begin\`, \`device.id\`, \`device.name\`, \`driver.id\`, \`driver.validation\`, \`duration\`, \`end\`,
      \`fuel.end\`, \`fuel.end.liters\`, \`fuel.start\`, \`fuel.start.liters\`, \`fuel.total.day\`, \`id\`, \`imei\`,
      \`odometer.end\`, \`odometer.start\`, \`odometer.total\`, \`timestamp\`)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE
      \`begin\` = VALUES(\`begin\`),
      \`device.id\` = VALUES(\`device.id\`),
      \`device.name\` = VALUES(\`device.name\`),
      \`driver.id\` = VALUES(\`driver.id\`),
      \`driver.validation\` = VALUES(\`driver.validation\`),
      \`duration\` = VALUES(\`duration\`),
      \`end\` = VALUES(\`end\`),
      \`fuel.end\` = VALUES(\`fuel.end\`),
      \`fuel.end.liters\` = VALUES(\`fuel.end.liters\`),
      \`fuel.start\` = VALUES(\`fuel.start\`),
      \`fuel.start.liters\` = VALUES(\`fuel.start.liters\`),
      \`fuel.total.day\` = VALUES(\`fuel.total.day\`),
      \`imei\` = VALUES(\`imei\`),
      \`odometer.end\` = VALUES(\`odometer.end\`),
      \`odometer.start\` = VALUES(\`odometer.start\`),
      \`odometer.total\` = VALUES(\`odometer.total\`),
      \`timestamp\` = VALUES(\`timestamp\`);
  `;

  const values = [
    data['begin'],
    data['device.id'],
    data['device.name'],
    JSON.stringify(data['driver.id']),
    data['driver.validation'],
    data['duration'],
    data['end'],
    data['fuel.end'],
    data['fuel.end.liters'],
    data['fuel.start'],
    data['fuel.start.liters'],
    data['fuel.total.day'],
    data['id'],
    data['imei'],
    data['odometer.end'],
    data['odometer.start'],
    data['odometer.total'],
    data['timestamp'],
  ];

  try {
    const result = await dbQuery(sql, values);
    return result.insertId;
  } catch (err) {
    throw err;
  }
}

async function IOU_1675142(data) {
  const sql = `
    INSERT INTO reports_1675142
      (\`avg.speed\`, \`begin\`, \`date\`, \`device.id\`, \`device.name\`, \`duration\`, \`end\`, \`id\`,
      \`idle.hours\`, \`imei\`, \`max.speed\`, \`motion.hours\`, \`motion.seconds\`, \`odometer.end\`,
      \`odometer.start\`, \`position.mileage\`, \`stop.hours\`, \`stop.seconds\`, \`timestamp\`,
      \`total.mileage\`, \`work.hours\`, \`work.seconds\`)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE
      \`avg.speed\` = VALUES(\`avg.speed\`),
      \`begin\` = VALUES(\`begin\`),
      \`date\` = VALUES(\`date\`),
      \`device.id\` = VALUES(\`device.id\`),
      \`device.name\` = VALUES(\`device.name\`),
      \`duration\` = VALUES(\`duration\`),
      \`end\` = VALUES(\`end\`),
      \`id\` = VALUES(\`id\`),
      \`idle.hours\` = VALUES(\`idle.hours\`),
      \`imei\` = VALUES(\`imei\`),
      \`max.speed\` = VALUES(\`max.speed\`),
      \`motion.hours\` = VALUES(\`motion.hours\`),
      \`motion.seconds\` = VALUES(\`motion.seconds\`),
      \`odometer.end\` = VALUES(\`odometer.end\`),
      \`odometer.start\` = VALUES(\`odometer.start\`),
      \`position.mileage\` = VALUES(\`position.mileage\`),
      \`stop.hours\` = VALUES(\`stop.hours\`),
      \`stop.seconds\` = VALUES(\`stop.seconds\`),
      \`timestamp\` = VALUES(\`timestamp\`),
      \`total.mileage\` = VALUES(\`total.mileage\`),
      \`work.hours\` = VALUES(\`work.hours\`),
      \`work.seconds\` = VALUES(\`work.seconds\`);
  `;

  const values = [
    data['avg.speed'],
    data['begin'],
    new Date(data['date']),
    data['device.id'],
    data['device.name'],
    data['duration'],
    data['end'],
    data['id'],
    data['idle.hours'],
    data['imei'],
    data['max.speed'],
    data['motion.hours'],
    data['motion.seconds'],
    data['odometer.end'],
    data['odometer.start'],
    data['position.mileage'],
    data['stop.hours'],
    data['stop.seconds'],
    data['timestamp'],
    data['total.mileage'],
    data['work.hours'],
    data['work.seconds'],
  ];

  try {
    const result = await dbQuery(sql, values);
    return result.insertId;
  } catch (err) {
    throw err;
  }
}

// async function IOU_1675136(data) {
//   const sql = `
//       INSERT INTO reports_1675136
//         (\`avg.speed\`, \`begin\`, \`can.trip.max.rpm\`, \`can.trip.mileage\`, \`can.trip.time\`, \`date.begin\`,
//         \`date.end\`, \`device.id\`, \`device.name\`, \`distance\`, \`distance_can\`, \`driver.id\`, \`duration\`,
//         \`duration.minutes\`, \`end\`, \`harsh.acceleration.event\`, \`harsh.braking.event\`,
//         \`harsh.cornering.event\`, \`id\`, \`imei\`, \`max.speed\`, \`route\`, \`timestamp\`, \`trip.fuel.consumed\`)
//       VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
//       ON DUPLICATE KEY UPDATE
//         \`avg.speed\` = VALUES(\`avg.speed\`),
//         \`begin\` = VALUES(\`begin\`),
//         \`can.trip.max.rpm\` = VALUES(\`can.trip.max.rpm\`),
//         \`can.trip.mileage\` = VALUES(\`can.trip.mileage\`),
//         \`can.trip.time\` = VALUES(\`can.trip.time\`),
//         \`date.begin\` = VALUES(\`date.begin\`),
//         \`date.end\` = VALUES(\`date.end\`),
//         \`device.id\` = VALUES(\`device.id\`),
//         \`device.name\` = VALUES(\`device.name\`),
//         \`distance\` = VALUES(\`distance\`),
//         \`distance_can\` = VALUES(\`distance_can\`),
//         \`driver.id\` = VALUES(\`driver.id\`),
//         \`duration\` = VALUES(\`duration\`),
//         \`duration.minutes\` = VALUES(\`duration.minutes\`),
//         \`end\` = VALUES(\`end\`),
//         \`harsh.acceleration.event\` = VALUES(\`harsh.acceleration.event\`),
//         \`harsh.braking.event\` = VALUES(\`harsh.braking.event\`),
//         \`harsh.cornering.event\` = VALUES(\`harsh.cornering.event\`),
//         \`id\` = VALUES(\`id\`),
//         \`imei\` = VALUES(\`imei\`),
//         \`max.speed\` = VALUES(\`max.speed\`),
//         \`route\` = VALUES(\`route\`),
//         \`timestamp\` = VALUES(\`timestamp\`),
//         \`trip.fuel.consumed\` = VALUES(\`trip.fuel.consumed\`);
//     `;

//   const values = [
//     data['avg.speed'],
//     data['begin'],
//     data['can.trip.max.rpm'],
//     data['can.trip.mileage'],
//     data['can.trip.time'],
//     new Date(data['date.begin']),
//     new Date(data['date.end']),
//     data['device.id'],
//     data['device.name'],
//     data['distance'],
//     data['distance_can'],
//     JSON.stringify(data['driver.id']),
//     data['duration'],
//     data['duration.minutes'],
//     data['end'],
//     data['harsh.acceleration.event'],
//     data['harsh.braking.event'],
//     data['harsh.cornering.event'],
//     data['id'],
//     data['imei'],
//     data['max.speed'],
//     data['route'],
//     data['timestamp'],
//     data['trip.fuel.consumed'],
//   ];

//   try {
//     const result = await dbQuery(sql, values);
//     return result.insertId;
//   } catch (err) {
//     throw err;
//   }
// }

// async function IOU_1674836(data) {
//   const sql = `
//     INSERT INTO reports_1674836
//       (\`begin\`, \`date\`, \`device.id\`, \`device.name\`, \`duration\`, \`end\`, \`id\`, \`imei\`, \`ip.peer\`, \`operador\`, \`server.key\`, \`ssl\`, \`timestamp\`)
//     VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
//     ON DUPLICATE KEY UPDATE
//       \`begin\` = VALUES(\`begin\`),
//       \`date\` = VALUES(\`date\`),
//       \`device.id\` = VALUES(\`device.id\`),
//       \`device.name\` = VALUES(\`device.name\`),
//       \`duration\` = VALUES(\`duration\`),
//       \`end\` = VALUES(\`end\`),
//       \`id\` = VALUES(\`id\`),
//       \`imei\` = VALUES(\`imei\`),
//       \`ip.peer\` = VALUES(\`ip.peer\`),
//       \`operador\` = VALUES(\`operador\`),
//       \`server.key\` = VALUES(\`server.key\`),
//       \`ssl\` = VALUES(\`ssl\`),
//       \`timestamp\` = VALUES(\`timestamp\`);
//   `;

//   const values = [
//     data.begin,
//     new Date(data.date),
//     data["device.id"],
//     data["device.name"],
//     data.duration,
//     data.end,
//     data.id,
//     data.imei,
//     data["ip.peer"],
//     JSON.stringify(data.operador),
//     data["server.key"],
//     data.ssl === "true", 
//     data.timestamp,
//   ];

//   try {
//     const result = await dbQuery(sql, values);
//     return result.insertId;
//   } catch (err) {
//     throw err;
//   }
// }






module.exports = {
  IOU_1674670,
  IOU_1674833,
  IOU_1675142,
  // IOU_1675136,
  // IOU_1674836,
};
