const express = require("express");
const router = express.Router();
const axios = require("axios");
const Calc = require("../models/calc");
const db = require("../config/dbConfig");

router.post("/calcs", async (req, res) => {
  try {
    const apiUrl = "https://flespi.io/gw/calcs/all";
    const headers = {
      Authorization: `FlespiToken ${process.env.FlespiToken}`,
    };

    const response = await axios.get(apiUrl, { headers });

    if (response.status === 200) {
      const calcsData = response.data.result; // Assuming 'result' is an array of calc data.

      for (const calc of calcsData) {
        // Call the createOrUpdateCalc function from your model to insert or update the data.
        Calc.createOrUpdateCalc(calc, (err, result) => {
          if (err) {
            console.error("Error:", err);
          }
        });
      }

      res.status(200).json({
        status: true,
        message: "Data retrieved and stored successfully",
        data: calcsData,
      });
    } else {
      res.status(500).json({
        status: false,
        error: "Failed to retrieve data from the API",
      });
    }
  } catch (error) {
    console.error("Error:", error);
    res.status(500).json({
      status: false,
      error: "An error occurred while fetching and storing data",
    });
  }
});

router.get("/calcs", (req, res) => {
  // Assuming you have a connection to your database already established

  // SQL query to retrieve data from the `calc` table
  const calcQuery = "SELECT * FROM calc";

  // Execute the query to fetch calc data
  db.query(calcQuery, (err, calcData) => {
    if (err) {
      console.error("Error:", err);
      res.status(500).json({
        status: false,
        error: "An error occurred while fetching calc data from the database",
      });
    } else {
      // Create an empty array to store the final response
      const responseData = {
        status: true,
        message: "Data retrieved successfully",
        data: [],
      };

      // Loop through the calc data
      for (const calc of calcData) {
        // Create an object for the current calc
        const calcResponse = {
          id: calc.id,
          intervals_ttl: calc.intervals_ttl,
          update_delay: calc.update_delay,
          update_period: calc.update_period,
          update_onchange: calc.update_onchange,
          name: calc.name,
          timezone: calc.timezone,
          version: calc.version,
          calc_counters: [],
          calc_selectors: [],
          calc_messages_source: [],
        };

        // SQL queries to retrieve related data based on calc_id
        const countersQuery = `SELECT * FROM calc_counters WHERE calc_id = ${calc.id}`;
        const selectorsQuery = `SELECT * FROM calc_selectors WHERE calc_id = ${calc.id}`;
        const messagesSourceQuery = `SELECT * FROM calc_messages_source WHERE calc_id = ${calc.id}`;

        // Fetch calc_counters data
        db.query(countersQuery, (err, countersData) => {
          if (err) {
            console.error("Error:", err);
            res.status(500).json({
              status: false,
              error: "An error occurred while fetching calc_counters data from the database",
            });
          } else {
            calcResponse.calc_counters = countersData;

            // Fetch calc_selectors data
            db.query(selectorsQuery, (err, selectorsData) => {
              if (err) {
                console.error("Error:", err);
                res.status(500).json({
                  status: false,
                  error: "An error occurred while fetching calc_selectors data from the database",
                });
              } else {
                calcResponse.calc_selectors = selectorsData;

                // Fetch calc_messages_source data
                db.query(messagesSourceQuery, (err, messagesSourceData) => {
                  if (err) {
                    console.error("Error:", err);
                    res.status(500).json({
                      status: false,
                      error: "An error occurred while fetching calc_messages_source data from the database",
                    });
                  } else {
                    calcResponse.calc_messages_source = messagesSourceData;

                    // Add the calc data with related data to the final response
                    responseData.data.push(calcResponse);

                    // Check if all calc records have been processed
                    if (responseData.data.length === calcData.length) {
                      // Send the final response as a JSON
                      res.json(responseData);
                    }
                  }
                });
              }
            });
          }
        });
      }
    }
  });
});

// router.get("/calcs/:calcId", (req, res) => {
//   const calcId = req.params.calcId;

//   // SQL query to retrieve data from the `calc` table for the specified calc_id
//   const calcQuery = `SELECT * FROM calc WHERE id = ${calcId}`;

//   // Execute the query to fetch calc data
//   db.query(calcQuery, (err, calcData) => {
//     if (err) {
//       console.error("Error:", err);
//       res.status(500).json({
//         status: false,
//         error: "An error occurred while fetching calc data from the database",
//       });
//     } else {
//       if (calcData.length === 0) {
//         // If no data is found for the specified calc_id, return a 404 response
//         res.status(404).json({
//           status: false,
//           error: "Calc with the specified ID not found",
//         });
//       } else {
//         // Create an object for the calc data
//         const calcResponse = {
//           id: calcData[0].id,
//           intervals_ttl: calcData[0].intervals_ttl,
//           update_delay: calcData[0].update_delay,
//           update_period: calcData[0].update_period,
//           update_onchange: calcData[0].update_onchange,
//           name: calcData[0].name,
//           timezone: calcData[0].timezone,
//           version: calcData[0].version,
//           calc_counters: [],
//           calc_selectors: [],
//           calc_messages_source: [],
//         };

//         // SQL queries to retrieve related data based on calc_id
//         const countersQuery = `SELECT * FROM calc_counters WHERE calc_id = ${calcId}`;
//         const selectorsQuery = `SELECT * FROM calc_selectors WHERE calc_id = ${calcId}`;
//         const messagesSourceQuery = `SELECT * FROM calc_messages_source WHERE calc_id = ${calcId}`;

//         // Fetch calc_counters data
//         db.query(countersQuery, (err, countersData) => {
//           if (err) {
//             console.error("Error:", err);
//             res.status(500).json({
//               status: false,
//               error: "An error occurred while fetching calc_counters data from the database",
//             });
//           } else {
//             calcResponse.calc_counters = countersData;

//             // Fetch calc_selectors data
//             db.query(selectorsQuery, (err, selectorsData) => {
//               if (err) {
//                 console.error("Error:", err);
//                 res.status(500).json({
//                   status: false,
//                   error: "An error occurred while fetching calc_selectors data from the database",
//                 });
//               } else {
//                 calcResponse.calc_selectors = selectorsData;

//                 // Fetch calc_messages_source data
//                 db.query(messagesSourceQuery, (err, messagesSourceData) => {
//                   if (err) {
//                     console.error("Error:", err);
//                     res.status(500).json({
//                       status: false,
//                       error: "An error occurred while fetching calc_messages_source data from the database",
//                     });
//                   } else {
//                     calcResponse.calc_messages_source = messagesSourceData;

//                     // Send the response for the specific calc_id
//                     res.json({
//                       status: true,
//                       message: "Data retrieved successfully",
//                       data: calcResponse,
//                     });
//                   }
//                 });
//               }
//             });
//           }
//         });
//       }
//     }
//   });
// });

// router.post("/calcs-daily-total-milage", async (req, res) => {
//   try {
//     const apiUrl = "https://flespi.io/gw/calcs/1673605/devices/all/intervals/all?data=%7B%22begin%22%3A0%2C%22count%22%3A1%2C%22end%22%3A0%2C%22fields%22%3A%22%22%7D";
//     const headers = {
//       Authorization: `FlespiToken ${process.env.FlespiToken}`,
//     };

//     const response = await axios.get(apiUrl, { headers });

//     if (response.status === 200) {
//       const calcsData = response.data.result;

//       const dataToInsert = calcsData.map((item) => {
//         return {
//           id: item.id,
//           begin: item.begin || 0,
//           daily_mileage: item.daily_mileage || 0,
//           duration: item.duration || 0,
//           end: item.end || 0,
//           mileage: item.mileage || 0,
//           route: item.route || '',
//           timestamp: item.timestamp || 0,
//           total_mileage: item.total_mileage || 0,
//         };
//       });

//       dataToInsert.forEach((data) => {
//         try { db.query(
//             `INSERT INTO calc_daily_total_milage (id, begin, daily_mileage, duration, end, mileage, route, timestamp, total_mileage) 
//              VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
//              ON DUPLICATE KEY UPDATE 
//              begin = VALUES(begin), daily_mileage = VALUES(daily_mileage), duration = VALUES(duration), 
//              end = VALUES(end), mileage = VALUES(mileage), route = VALUES(route), 
//              timestamp = VALUES(timestamp), total_mileage = VALUES(total_mileage)`,
//             [data.id, data.begin, data.daily_mileage, data.duration, data.end, data.mileage, data.route, data.timestamp, data.total_mileage]
//           );
//         } catch (error) {
//           console.error("Error inserting/updating data:", error);
//         }
//       });

//       res.status(200).json({
//         status: true,
//         message: "Data retrieved and stored successfully",
//         data: calcsData,
//       });
//     } else {
//       res.status(500).json({
//         status: false,
//         error: "Failed to retrieve data from the API",
//       });
//     }
//   } catch (error) {
//     console.error("Error:", error);
//     res.status(500).json({
//       status: false,
//       error: "An error occurred while fetching and storing data",
//     });
//   }
// });

// router.get("/calcs-daily-total-milage", async (req, res) => {
//   try {
//     const query = "SELECT * FROM calc_daily_total_milage;";
//     const results = await new Promise((resolve, reject) => {
//       db.query(query, (error, results) => {
//         if (error) {
//           console.error("Error:", error);
//           reject(error);
//         } else {
//           resolve(results);
//         }
//       });
//     });
  
//     res.status(200).json({
//       status: true,
//       message: "Data retrieved successfully",
//       data: results,
//     });
//   } catch (error) {
//     console.error("Error:", error);
//     res.status(500).json({
//       status: false,
//       error: "An error occurred while fetching data",
//     });
//   }
  
// });





module.exports = router;
