const db = require("../config/dbConfig");

async function insertDrivers(data) {
  const sql = `
    INSERT INTO drivers_reg (first_name, last_name, grade, internal_code, license_id, dni, email, phone, rfid_card, station)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
  `;

  try {
    await db.query(sql, [
      data.first_name,
      data.last_name,
      data.grade,
      data.internal_code,
      data.license_id,
      data.dni,
      data.email,
      data.phone,
      data.rfid_card,
      data.station,
    ]);
    console.log("Data inserted successfully.");
  } catch (error) {
    console.error("Error while inserting data:", error);
    throw error; 
  }
}

function getDrivers(callback) {
  const driversSql = "SELECT * FROM drivers_reg WHERE deleted_at IS NULL ORDER BY created_at DESC";
  db.query(driversSql, (error, driversResults) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, driversResults);
    }
  });
}

function deleteDriver(driverId, callback) {
  const deleteSql = "UPDATE drivers_reg SET deleted_at = CURRENT_TIMESTAMP WHERE id = ?";
  db.query(deleteSql, [driverId], (error, result) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, result);
    }
  });
}

function updateDriver(driverId, updatedData, callback) {
  const updateSql = "UPDATE drivers_reg SET ? WHERE id = ?";
  db.query(updateSql, [updatedData, driverId], (error, result) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, result);
    }
  });
}

function getAllDriversIds(callback) {
  const driversSql = `
    SELECT driver_id FROM calc_fuel_consumed
    UNION
    SELECT driver_id FROM calc_refuel
  `;

  db.query(driversSql, (error, driversResults) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, driversResults);
    }
  });
}

module.exports = {
  insertDrivers,
  getDrivers,
  deleteDriver,
  updateDriver,
  getAllDriversIds,
};
