function getGMTTimestampsForDay(day) {
  const currentDate = new Date();

  let targetDate;
  if (day === "dayBefore") {
    targetDate = new Date(
      Date.UTC(
        currentDate.getUTCFullYear(),
        currentDate.getUTCMonth(),
        currentDate.getUTCDate() - 1,
        0,
        0,
        0,
        0
      )
    );
  } else {
    targetDate = new Date(
      Date.UTC(
        currentDate.getUTCFullYear(),
        currentDate.getUTCMonth(),
        currentDate.getUTCDate(),
        0,
        0,
        0,
        0
      )
    );
  }

  const startOfDay = targetDate;
  const endOfDay = new Date(
    Date.UTC(
      targetDate.getUTCFullYear(),
      targetDate.getUTCMonth(),
      targetDate.getUTCDate(),
      23,
      59,
      59,
      999
    )
  );

  const startOfDayTimestamp = Math.floor(startOfDay.getTime() / 1000);
  // console.log("startOfDayTimestamp: ", startOfDayTimestamp)
  const endOfDayTimestamp = Math.floor(endOfDay.getTime() / 1000);
  // console.log("endOfDayTimestamp: ", endOfDayTimestamp)

  return {
    startOfDay: startOfDayTimestamp,
    endOfDay: endOfDayTimestamp,
  };
}

function getMatchingDevices(ident, flespiDevices) {
  const matchedDevices = [];

  ident.forEach(identValue => {
      const matchingDevice = flespiDevices.find(device =>
          device.configuration.ident === identValue
      );

      if (matchingDevice) {
          matchedDevices.push(matchingDevice.id);
      }
  });

  return matchedDevices;
}

function formatDDMY(timestamp) {
  const timestampMilliseconds = timestamp * 1000;

  const date = new Date(timestampMilliseconds);

  date.setUTCHours(date.getUTCHours() - 5);

  const months = [
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "May",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec",
  ];

  const days = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];

  const day = days[date.getUTCDay()];
  const month = months[date.getUTCMonth()];
  const year = date.getUTCFullYear();
  const hours = String(date.getUTCHours()).padStart(2, "0");
  const minutes = String(date.getUTCMinutes()).padStart(2, "0");

  const formattedDate = `${day} ${month} ${date.getUTCDate()} ${year}`;

  return formattedDate;
}

function formatTimestamp(timestamp) {
  const timestampMilliseconds = timestamp * 1000;
  const date = new Date(timestampMilliseconds);

  return formatDate(date);
}

function formatDate(date) {
  const months = [
    "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
  ];

  const days = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];

  const day = days[date.getUTCDay()];
  const month = months[date.getUTCMonth()];
  const year = date.getUTCFullYear();

  return `${day} ${month} ${date.getUTCDate()} ${year}`;
}


function formatTimeISO(dateString) {
  const date = new Date(dateString);
  const days = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
  const months = [
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
  ];
  const day = days[date.getUTCDay()];
  const month = months[date.getUTCMonth()];
  const year = date.getUTCFullYear();
  const dateStr = `${day} ${month} ${date.getUTCDate()} ${year}`;
  const timeStr = date.toLocaleTimeString('en-US', { hour12: false });
  return `${dateStr} ${timeStr}`;
}

function formatTimeISOGMTMINUS5(dateString) {
  const date = new Date(dateString);
  const offset = -5 * 60 * 60 * 1000;
  const localTime = date.getTime();
  const adjustedTime = new Date(localTime + offset);
  const days = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
  const months = [
      "Jan", "Feb", "Mar", "Apr", "May", "Jun",
      "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
  ];
  const day = days[adjustedTime.getUTCDay()];
  const month = months[adjustedTime.getUTCMonth()];
  const year = adjustedTime.getUTCFullYear();
  const dateStr = `${day} ${month} ${adjustedTime.getUTCDate()} ${year}`;
  
  const timeStr = adjustedTime.toISOString().substr(11, 8);
  
  return `${dateStr} ${timeStr}`;
}


module.exports = {
  getGMTTimestampsForDay,
  getMatchingDevices,
  formatDDMY,
  formatTimestamp,
  formatTimeISO,
  formatTimeISOGMTMINUS5
};
