const db = require("../config/dbConfig");

async function insertOrUpdateCalcDailyReports(dataArray) {
  const sql = `
    INSERT INTO calc_daily_reports (data_id,calc_id,device_id,begin,imei,duration,end,timestamp,avg_speed,max_speed,motion_hours,motion_seconds,odometer_end,odometer_start,position_mileage,idle_hours,running_seconds,stop_hours,stop_seconds,total_mileage,work_hours)
      VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
      ON DUPLICATE KEY UPDATE
      timestamp = VALUES(timestamp);
    `;

  for (const item of dataArray) {
    try {
      await db.query(sql, [
        item.id,
        item.calc_id,
        // item.calc_name,
        item["device.id"],
        // item.device_name,
        item.begin,
        item.imei,
        item.duration,
        item.end,
        item.timestamp,
        item["avg.speed"],
        item["max.speed"],
        item["motion.hours"],
        item["motion.seconds"],
        item["odometer.end"],
        item["odometer.start"],
        item["position.mileage"],
        item["idle.hours"],
        item["running.seconds"],
        item["stop.hours"],
        item["stop.seconds"],
        item["total.mileage"],
        item["work.hours"],
      ]);
    } catch (error) {
      console.error("Error while inserting or updating data:", error);
    }
  }
}

function getCalcDailyReports(callback) {
  const calcBitrekSql = "SELECT * FROM calc_daily_reports";
  db.query(calcBitrekSql, (error, calcBitrekResults) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, calcBitrekResults);
    }
  });
}

function getAllDevicesCalcs(callback) {
  const AllDevicesCalcsSql = "SELECT * FROM devices_calcs";
  db.query(AllDevicesCalcsSql, (error, AllDevicesCalcResults) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, AllDevicesCalcResults);
    }
  });
}

function getCalcDailyReportsByDeviceId(deviceIdsArray, callback) {
  if (deviceIdsArray.length === 0) {
    callback(null, []);
    return;
  }
  const deviceIdQuery = "SELECT * FROM calc_daily_reports WHERE device_id IN (?)";
  db.query(deviceIdQuery, [deviceIdsArray], (error, result) => {
    if (error) {
      console.error("Error:", error);
      callback(error, null);
    } else {
      callback(null, result);
    }
  });
}

module.exports = {
  insertOrUpdateCalcDailyReports,
  getCalcDailyReports,
  getCalcDailyReportsByDeviceId,
  getAllDevicesCalcs
};
