const db = require("../config/dbConfig");

async function insertSubAccountToken(data) {
  const sql = `
  INSERT INTO sub_account_tokens (ips, token_id, expire, created, token, ttl, info, cid, access_type)
      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
      ON DUPLICATE KEY UPDATE
        ips = VALUES(ips),
        token_id = VALUES(token_id),
        expire = VALUES(expire),
        created = VALUES(created),
        ttl = VALUES(ttl),
        info = VALUES(info),
        access_type = VALUES(access_type),
        token = VALUES(token);
    `;

  try {
    await db.query(sql, [
      data.ips,
      data.id,
      data.expire,
      data.created,
      data.key,
      data.ttl,
      data.info,
      data.cid,
      data.access.type,
    ]);
    console.log("Data inserted successfully.");
    return true;
  } catch (error) {
    console.error("Error while inserting data:", error);
    return false;
  }
}

function getFlespiToken(callback) {
  const FlespiTokenSql = 'SELECT * FROM sub_account_tokens';
  db.query(FlespiTokenSql, (error, FlespiTokenResults) => {
      if (error) {
          console.error('Error:', error);
          callback(error, null);
      } else {
          callback(null, FlespiTokenResults);
      }
  });
}


function getFlespiTokenById(traccarUserId, callback) {
  const FlespiTokenByIdSql = 'SELECT * FROM sub_account_tokens WHERE cid = ?';
  db.query(FlespiTokenByIdSql, [traccarUserId], (error, FlespiTokenByIdResults) => {
      if (error) {
          console.error('Error:', error);
          callback(error, null);
      } else {
          callback(null, FlespiTokenByIdResults);
      }
  });
}

module.exports = {
  insertSubAccountToken,
  getFlespiToken,
  getFlespiTokenById
};
