const db = require('../config/dbConfig');

const Calc = {};

Calc.createOrUpdateCalc = (data, callback) => {
  const checkIfExistsQuery = 'SELECT id FROM calc WHERE id = ?';

  db.query(checkIfExistsQuery, [data.id], (checkErr, checkResult) => {
    if (checkErr) {
      callback(checkErr, null);
    } else {
      if (checkResult.length === 0) {
        const calcQuery = `
          INSERT INTO calc
          (id, intervals_ttl, update_delay, update_period, update_onchange, name, timezone, version)
          VALUES (?, ?, ?, ?, ?, ?, ?, ?)`;

        const calcValues = [
          data.id,
          data.intervals_ttl,
          data.update_delay,
          data.update_period,
          data.update_onchange,
          data.name,
          data.timezone,
          data.version,
        ];

        db.query(calcQuery, calcValues, (calcErr, calcResult) => {
          if (calcErr) {
            callback(calcErr, null);
          } else {
            const messagesSourceQuery = `
              INSERT INTO calc_messages_source
              (calc_id, source)
              VALUES (?, ?)
              ON DUPLICATE KEY UPDATE
              source = VALUES(source)`;

            const messagesSourceValues = [
              data.id,
              data.messages_source.source,
            ];

            db.query(messagesSourceQuery, messagesSourceValues, (messagesSourceErr, messagesSourceResult) => {
              if (messagesSourceErr) {
                callback(messagesSourceErr, null);
              } else {
                for (const selector of data.selectors) {
                  const selectorsQuery = `
                    INSERT INTO calc_selectors
                    (calc_id, expression, max_inactive, max_messages_time_diff, merge_message_after, merge_message_before, merge_unknown, method, min_duration, type)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                    ON DUPLICATE KEY UPDATE
                    max_inactive = VALUES(max_inactive),
                    max_messages_time_diff = VALUES(max_messages_time_diff),
                    merge_message_after = VALUES(merge_message_after),
                    merge_message_before = VALUES(merge_message_before),
                    merge_unknown = VALUES(merge_unknown),
                    method = VALUES(method),
                    min_duration = VALUES(min_duration),
                    type = VALUES(type)`;

                  const selectorValues = [
                    data.id,
                    selector.expression,
                    selector.max_inactive,
                    selector.max_messages_time_diff,
                    selector.merge_message_after,
                    selector.merge_message_before,
                    selector.merge_unknown,
                    selector.method,
                    selector.min_duration,
                    selector.type,
                  ];

                  db.query(selectorsQuery, selectorValues, (selectorsErr, selectorsResult) => {
                    if (selectorsErr) {
                      callback(selectorsErr, null);
                    }
                  });
                }

                for (const counter of data.counters) {
                  const countersQuery = `
                    INSERT INTO calc_counters
                    (calc_id, expression, method, name, type, fields, validate_message, parameter, reset_interval)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
                    ON DUPLICATE KEY UPDATE
                    method = VALUES(method),
                    name = VALUES(name),
                    type = VALUES(type),
                    fields = VALUES(fields),
                    validate_message = VALUES(validate_message),
                    parameter = VALUES(parameter),
                    reset_interval = VALUES(reset_interval)`;

                  const countersValues = [
                    data.id,
                    counter.expression,
                    counter.method,
                    counter.name,
                    counter.type,
                    JSON.stringify(counter.fields),
                    counter.validate_message,
                    counter.parameter,
                    counter.reset_interval,
                  ];

                  db.query(countersQuery, countersValues, (countersErr, countersResult) => {
                    if (countersErr) {
                      callback(countersErr, null);
                    }
                  });
                }

                callback(null, calcResult);
              }
            });
          }
        });
      } else {
        callback(null, 'Record already exists');
      }
    }
  });
};

module.exports = Calc;
